import data.real.irrational
import topology.basic
import algebra.order.floor


--OUTPUT 1
theorem irrational_orbit_dense {α : ℝ} (hα_irrat : irrational α) : closure ((λ m : ℤ, int.fract (α * ↑m)) '' (@set.univ ℤ)) = set.Icc 0 1 :=
begin
  -- Let $\alpha$ be an irrational number. Then for distinct $i, j \in \mathbb{Z}$, we must have $\{i \alpha\} \neq\{j \alpha\}$. 
  let i j (h1 : i ≠ j) := begin
    assume h2 : α * ↑i = α * ↑j,
    have h3 : i - j = 0, from by linarith,
    have h4 : i = j, from by linarith [h3],
    show false, from h4 h1,
  end,

  -- Then for distinct $i, j \in \mathbb{Z}$, we must have $\{i \alpha\} \neq\{j \alpha\}$. 
  have h5 : ∀ i j : ℤ, i ≠ j → (∃ (i j : ℤ) (h1 : i ≠ j) (h2 : i - j ≠ 0), int.fract (α * ↑i) ≠ int.fract (α * ↑j)), 
  from by auto [hα_irrat, int.fract_ne_iff, h1] using [int],
  
  -- If this were not true, then
  -- $\forall i j : ℤ, i ≠ j → (∃ (i j : ℤ) (h1 : i ≠ j) (h2 : i - j ≠ 0), int.fract (α * ↑i) ≠ int.fract (α * ↑j))$
  have h6 : ∀ i j : ℤ, i ≠ j → (∃ (i j : ℤ) (h1 : i ≠ j)  (h2 : i - j ≠ 0), int.fract (α * ↑i) ≠ int.fract (α * ↑j)), 
  from by auto [h5],

  -- Hence,
  -- $S:=\{\{i \alpha\} \mid i \in \mathbb{Z}\}$
  -- is an infinite subset of $\left[0,1\right]$.
  have h7 : (λ m : ℤ, int.fract (α * ↑m)) '' set.univ ≠ ∅, from by auto [by auto [h6]],
  
  -- $S$ has a limit point in $[0, 1]$.
  have h8 : closure ((λ m : ℤ, int.fract (α * ↑m)) '' set.univ) ≠ ∅, from by auto [h7],
  have h9 : closure ((λ m : ℤ, int.fract (α * ↑m)) '' set.univ) ∈ 𝒩 𝕜, from by auto [h8],
  have h10 : ∃ (A : set ℝ) (d : ℝ), closure ((λ m : ℤ, int.fract (α * ↑m)) '' set.univ) = closure A ∧ A ⊆ upper_bounds A ∧ ∃ l ∈ A, ∀ x ∈ A, l ≤ x ∧ ∃ a ∈ A, a = l + d, 
  from by auto [h9],
  cases h10 with A h11,
  cases h11 with d h12,
  cases h12 with h13 h14,
  cases h14 with h15 h16, 
  have h16a : ∃ l ∈ A, ∀ x ∈ A, l ≤ x ∧ ∃ a ∈ A, a = l + d, from by auto [h16],
  cases h16a with l h16b,
  cases h16b with h16c h17,
  have h18 : ∀ x ∈ A, l ≤ x ∧ ∃ a ∈ A, a = l + d, from by auto [h17],
  have h19 : ∃ a ∈ A, a = l + d, from by auto [h18],
  cases h19 with a h20,
  cases h20 with h20a h21,
  have h22 : ∀ x ∈ A, l ≤ x, from by auto [h18],
  have h23 : ∀ x ∈ A, l + d ≤ x, from by auto [h18, le_add_iff_nonneg_right],
  have h24 : ∀ x ∈ A, l + d < x, from by auto [h23],
  have h25 : {l + d} ⊆ A, from by auto [h22, le_add_iff_nonneg_right, h21, h24],
  have h26 : {l + d} ⊆ closure A, from by auto [set.subset_closure_iff, h25],
  have h26a : {l + d} ⊆ closure ((λ m : ℤ, int.fract (α * ↑m)) '' set.univ), from by auto [h13, h26],
  have h27 : l ∈ A, from by auto [h16c],
  have h28 : l ∈ closure A, from by auto [set.mem_closure_iff, h27],
  have h28a : l ∈ closure ((λ m : ℤ, int.fract (α * ↑m)) '' set.univ), from by auto [h13, h28],
  have h29 : ∃ x ∈ closure ((λ m : ℤ, int.fract (α * ↑m)) '' set.univ), x < l + d, from by auto [h22, h27, h26a, h28a, lt_add_iff_pos_right],
  cases h29 with x h30,
  cases h30 with h30a h30b,
  have h31 : ∀ x ∈ closure ((λ m : ℤ, int.fract (α * ↑m)) '' set.univ), x < l + d, from begin
    assume x h31,
    have h32 : ∃ x ∈ A, x < l + d, from by auto [h28, h30a, h31, set.mem_closure_iff],
    cases h32 with y h33,
    cases h33 with h33a h33b,
    show x < l + d, from by auto [h17, h33a, h33b],
  end,
  have h32 : ∀ x ∈ closure ((λ m : ℤ, int.fract (α * ↑m)) '' set.univ), l + d - x > 0, from begin
    assume x h32,
    have h33 : x < l + d, from by auto [h31, h32],
    show l + d - x > 0, from by auto [h33, sub_pos_iff] using [linarith],
  end,

  --By the Bolzano-Weierstrass theorem, $S$ has a limit point in $[0, 1]$.
  have h40 : ∀ (δ > 0), ¬ ∀ a : ℝ, (∃ (a : ℝ), a ∉ lower_bounds A ∧ 0 < a ∧ a < δ) → (∃ (a : ℝ), a ∉ upper_bounds A ∧ (-δ) < a ∧ a < 0), from by auto [real.nmul_lt_mul_of_pos, real.nlt_ge],
  have h41 : ∀ (δ > 0), ¬ ∀ a : ℝ, (∃ (a : ℝ), a ∉ lower_bounds A ∧ 0 < a ∧ a < δ) → (∃ (a : ℝ), a ∉ upper_bounds A ∧ (-d) < a ∧ a < 0), from by auto [h40, h32],
  have h42 : ∀ (δ > 0), ¬ ∀ a : ℝ, (∃ (a : ℝ), a ∉ A ∧ 0 < a ∧ a < δ) → (∃ (a : ℝ), a ∉ A ∧ (-d) < a ∧ a < 0), from by auto [h41],
  have h43 : ∀ (δ > 0), ¬ ∀ a : ℝ, (∃ (a : ℝ), a ∉ closure A ∧ 0 < a ∧ a < δ) → (∃ (a : ℝ), a ∉ closure A ∧
end --Needs more than 2000 tokens!

--OUTPUT 2
theorem irrational_orbit_dense {α : ℝ} (hα_irrat : irrational α) : closure ((λ m : ℤ, int.fract (α * ↑m)) '' (@set.univ ℤ)) = set.Icc 0 1 :=
begin
-- Let $\alpha$ be an irrational number. Then for distinct $i, j \in \mathbb{Z}$, we must have $\{i \alpha\} \neq\{j \alpha\}$. If this were not true, then:
  have h1 : ∀ i j : ℤ, i ≠ j → ⟪i * α⟫ ≠ ⟪j * α⟫,
  begin
    assume i j,
    assume h2,
    assume h3,
    --Then $i \alpha-\lfloor i \alpha\rfloor=\{i \alpha\}=\{j \alpha\}=j \alpha-\lfloor j \alpha\rfloor$,
    have h4 : ⟪i * α⟫ = ⟪j * α⟫, from by auto [h3],
    -- which yields the false statement $\alpha=\frac{\lfloor i \alpha\rfloor-\lfloor j \alpha\rfloor}{i-j} \in \mathbb{Q}$.
    have h5 : α = ⟪i * α⟫ - ⟪j * α⟫, from by auto [h4, int.fract_def],
    have h6 : α = ⟪i * α⟫ / ↑i - ⟪j * α⟫ / ↑i, from by auto [fraction_to_real, div_sub_div],
    have h7 : α * ↑i = (⟪i * α⟫ * ↑i) / ↑i - (⟪j * α⟫ * ↑i) / ↑i, from by auto [mul_div_cancel],
    have h8 : α * ↑i = ⟪i * α⟫ - ⟪j * α⟫, from by auto [h7, mul_comm],
    have h9 : ↑i ≠ 0, from by auto [eq_zero_iff_eq_zero],
    have h10 : α = ((⟪i * α⟫ - ⟪j * α⟫) * ↑i⁻¹) * ↑i, from by auto [mul_assoc, mul_inv_cancel, h9],
    have h11 : α = (⟪i * α⟫ - ⟪j * α⟫) * ↑i⁻¹, from by auto [mul_comm, h10],
    have h12 : α = (⟪i * α⟫ - ⟪j * α⟫) / ↑i, from by auto [mul_inv_cancel] using [h9],
    have h13 : α ∈ @set.univ ℤ → α ∈ @set.univ ℚ, from by auto [fraction_to_real],
    have h14 : α ∈ @set.univ ℤ, from by auto [h1, h2],
    have h15 : α ∈ @set.univ ℚ, from by auto [h13, h14],
    have h16 : α ∈ @set.univ ℝ, from by auto [rat_to_real, h15],
    exact hα_irrat h16,
  end,

-- Hence, $S:=\{\{i \alpha\} \mid i \in \mathbb{Z}\}$ is an infinite subset of $\left[0,1\right]$.
  have h17 : (@set.univ ℤ) ≠ ∅, from by auto [set.univ_ne_empty],
  have h18 : (λ m : ℤ, ⟪m * α⟫) '' (@set.univ ℤ) ≠ ∅, from by auto [set.mem_image_of_mem, set.mem_univ],
  have h19 : (λ m : ℤ, ⟪m * α⟫) '' (@set.univ ℤ) ⊆ real.Ioo 0 1, from by auto [int.fract_nonneg, int.fract_lt_one],
  have h20 : (λ m : ℤ, ⟪m * α⟫) '' (@set.univ ℤ) ⊆ (λ m : ℝ, ⟪m⟫) '' (real.Ioo 0 1), from by auto [int.fract_mono] using [int.fract_nonneg, int.fract_lt_one],
  have h21 : (λ m : ℤ, ⟪m * α⟫) '' (@set.univ ℤ) ⊆ set.Icc 0 1, from by auto [int.fract_eq_zero_or_one, set.mem_Icc_iff],
  
-- By the Bolzano-Weierstrass theorem, $S$ has a limit point in $[0, 1]$. 
  have h22 : (λ m : ℤ, ⟪m * α⟫) '' (@set.univ ℤ) ≠ ∅, from by auto [h18],
  
--One can thus find pairs of elements of $S$ that are arbitrarily close. Since (the absolute value of) the difference of any two elements of $S$ is also an element of $S$, it follows that $0$ is a limit point of $S$.
  have h23 : ∀ ε > 0, ∃ x y : ℝ, (x ≠ y) ∧ (x - y ∈ real.Ioo 0 ε) ∧ (x ∈ real.Ioo 0 1) ∧ (y ∈ real.Ioo 0 1), 
  from by auto [hα_irrat] using [int.fract_ne_int, int.fract_nonneg, int.fract_lt_one],
  have h24 : ∀ ε > 0, ∃ x y : ℝ, (x ≠ y) ∧ (x - y ∈ real.Ioo 0 ε) ∧ (x ∈ set.Icc 0 1) ∧ (y ∈ set.Icc 0 1), 
  from by auto [int.fract_eq_zero_or_one, set.mem_Icc_iff] using [h23],
  have h25 : ∃ x y : ℝ, (x ≠ y) ∧ (x - y ∈ real.Ioo 0 1) ∧ (x ∈ set.Icc 0 1) ∧ (y ∈ set.Icc 0 1), 
  from by auto [h24] using [set.mem_Ioo_iff],
  have h26 : ∃ x y : ℝ, (x ≠ y) ∧ (x - y ∈ real.Ioo 0 1) ∧ (x ∈ set.Icc 0 1) ∧ (y ∈ set.Icc 0 1) ∧ (x ∈ (λ m : ℤ, ⟪m * α⟫) '' (@set.univ ℤ)) ∧ (y ∈ (λ m : ℤ, ⟪m * α⟫) '' (@set.univ ℤ)), 
  from by auto [set.mem_Icc_iff, set.mem_image_of_mem, set.mem_univ, h25, int.fract_nonneg, int.fract_lt_one],
  have h27 : ∃ x y : ℝ, (x ≠ y) ∧ (x - y ∈ (λ m : ℤ, ⟪m * α⟫) '' (@set.univ ℤ)) ∧ (x ∈ (λ m : ℤ, ⟪m * α⟫) '' (@set.univ ℤ)) ∧ (y ∈ (λ m : ℤ, ⟪m * α⟫) '' (@set.univ ℤ)), 
  from by auto [int.fract_ne_int, set.mem_image_of_mem, set.mem_univ] using [h26],
  
-- To show that $S$ is dense in $[0, 1]$, consider $y \in[0,1]$, and $\epsilon>0$. 
  have h28 : ∀ y : ℝ, (y ∈ real.Ioo 0 1) → (∀ ε : ℝ, ε
end --Needs more than 2000 tokens!

--OUTPUT 3
theorem irrational_orbit_dense {α : ℝ} (hα_irrat : irrational α) : closure ((λ m : ℤ, int.fract (α * ↑m)) '' (@set.univ ℤ)) = set.Icc 0 1 := 
begin
  let h1 := λ m₁ m₂ : ℤ, m₁ ≠ m₂ → int.fract (α * ↑m₁) ≠ int.fract (α * ↑m₂),
  let h2 := λ (i : ℤ), int.fract (α * ↑i),
  let S := (λ (n : ℤ), int.fract (α * ↑n)) '' (@set.univ ℤ),
  let h3 := λ a : ℤ, a ∉ S,
  let h4 := λ (a : ℤ) (h4a : a ∉ S), - a ∉ S,
  let h5 := λ (n : ℤ) (hn : n ∉ S), abs n ∉ S,
  let h6 := λ (a : ℤ) (h4a : a ∉ S) (h6a : - a ∉ S), h4a.symm ▸ h6a.symm,
  let h7 := λ (n : ℤ) (hn : n ∉ S) (hn' : abs n ∉ S), (le_total 0 n) ▸
  (or.imp (λ hn_pos : 0 < n, hn) (λ hn_neg : n < 0, hn')
  (abs_of_pos hn_pos)),
  let h8  := λ (n : ℤ) (h4n : n ∉ S) (h6n : - n ∉ S) (hn' : abs n ∉ S),
  or.imp_right (le_total 0 n) (λ hn_neg : n < 0, h5 (-n) (h4 n)) hn',
  let h9 := λ (n : ℤ) (h4n : n ∉ S) (h6n : - n ∉ S) (hn' : abs n ∉ S) (hn_neg : n < 0),
  (h6n (h5 (-n) (h4n))).elim,
  let h10 := λ (n : ℤ) (h4n : n ∉ S) (h6n : - n ∉ S) (hn' : abs n ∉ S) (hn_neg : n < 0), @sub_zero ℤ n,
  let h11 := λ (n : ℤ) (h4n : n ∉ S) (h6n : - n ∉ S) (hn' : abs n ∉ S) (hn_neg : n < 0) (hn_sub0 : n - 0 = n),
  have hn₁ : n ≠ 0, from eq.subst (neg_zero n) (eq.subst (sub_zero n) hn_sub0).symm ▸ hn_neg,
  have hn₂ : - n ≠ 0, from neg_ne_zero_of_ne_zero hn₁,
  have h12 := abs_neg n,
  have h13 : n = - n := (eq.subst (sub_zero n) hn_sub0).symm ▸ (eq.subst (neg_zero n) (eq.subst (sub_zero n) hn_sub0).symm),
  have h14 := (h7 n (h4n) (h6n) (abs_pos_of_neg hn_neg)),
  assume (hn₃ : - n ∈ S),
  have h15 : n ∈ S := h6n hn₃,
  have h16 := (h4n h15),
  have h17 := (h4n (S.not_mem_empty n)),
  have h18 := h9 n h4n h6n (abs_pos_of_neg hn_neg) (neg_of_neg_nonpos hn_neg) hn₂,
  show false, from h17.elim,
  
  let h19 := λ (y : ℝ) (h19y : y ∈ closure S),
  let h20 := λ (ε : ℝ) (h20ε : ε > 0),
  let h21 := λ (x : ℤ) (h21x : x ∈ S) (h22x : x < y + ε),
  have h23 : y + ε - x > x - y, from sub_lt_iff_lt_add'.mp (iff.intro h22x
  (by linarith)),
  have h24 : x - y > - ε, from (iff.intro (le_of_lt (lt_trans h22x h23)) (by linarith)),
  have h25 : abs (x - y) < ε, from abs_of_neg_lt_of_lt (neg_lt_zero_of_ne_zero_of_lt h20ε) h24,
  use x,
  assume (hn_y : y ∈ S), assumption,
  show ∃ (x₀ : ℤ), x₀ ∈ S ∧ x₀ < y + ε, from ⟨int.fract((y+ε)*(1/ε)), set.mem_image_of_mem h2 (int.mem_image_iff.mp
  (int.coe_nat_dvd_iff.mpr (exists_eq_mul_left_of_dvd (int.dvd_fract ((y+ε)*(1/ε)))
  (int.coe_nat_ne_zero_iff_pos.mpr (int.pos_of_ne_zero
  (λ hne : (1/ε)=0, by linarith)))))).mp one_lt_two,
  (by linarith)⟩,
  use ε,
  assume h20ε,
  let h21 := h21 y (h19y S.univ_mem_univ) h20ε,
  cases h21 with x h21,
  use x,
  assume hn_y,
  exact h21.right,
  let h22 := λ (y : ℝ) (h19y : y ∈ closure S),
  let h23 := (h19y S.univ_mem_univ),
  let h24 := λ (ε : ℝ) (h24ε : ε > 0),
  let h25 := λ (n₁ n₂ n : ℤ) (h26 : n₁ * abs n + n₂ < n),
  have h27 : n₁ * abs n + n₂ < abs n + n, from add_lt_add (le_of_lt h26) ((abs_pos_of_ne_zero
  (λ hn0 : abs n = 0, by linarith)).right),
  have h28 := (mul_le_mul_left (abs n) (abs_nonneg n) (abs_nonneg n₁)
  (add_le_add (le_abs_self n₁) (le_abs_self n₂))),
  have h29 : (n₁ * abs n > 0) → (n₁ * abs n + n₂ < abs n + n), from (le_of_not_ge
  (λ hn_ge, (not_lt_of_ge hn_ge).elim)),
  have h30 : (n₁ * abs n > 0) ∧ (n₁ * abs n < n), from and.intro
  (by linarith) (iff.mp (lt_iff_le_and_ne.mp h26).right.symm hn_ge),
  have h31 : n₁ * abs n + n₂ < n, from @lt_of_lt_of_le ℤ (n₁ * abs n + n₂) (n₁ * abs n) (abs n + n)
  hn_ge h28,
  have h32 : ∃ (n₁ n₂ n : ℤ), n₁ * abs n + n₂ < n, from exists.intro n₁ (exists.intro n₂ (exists.intro n h26)),
  have h33 :=
end --Needs more than 2000 tokens!

--OUTPUT 4
theorem irrational_orbit_dense {α : ℝ} (hα_irrat : irrational α) : closure ((λ m : ℤ, int.fract (α * ↑m)) '' (@set.univ ℤ)) = set.Icc 0 1 :=
begin
  -- Let $\alpha$ be an irrational number. Then for distinct $i, j \in \mathbb{Z}$, we must have $\{i \alpha\} \neq\{j \alpha\}$.
  -- If this were not true, then $i \alpha-\lfloor i \alpha\rfloor=\{i \alpha\}=\{j \alpha\}=j \alpha-\lfloor j \alpha\rfloor$, which yields the false statement $\alpha=\frac{\lfloor i \alpha\rfloor-\lfloor j \alpha\rfloor}{i-j} \in \mathbb{Q}$. Hence, $S:=\{\{i \alpha\} \mid i \in \mathbb{Z}\}$ is an infinite subset of $\left[0,1\right]$.
  have h1 : ∀ (i j : ℤ), i ≠ j → int.fract (α*↑i) ≠ int.fract (α*↑j), 
  from by auto [hα_irrat, int.lt_irrefl, irrat_def, int.lt_add_one_iff, int.le_iff_lt_or_eq, int.lt_iff_le_not_le, int.fract_eq_iff_of_int, int.fract_self, int.fract_eq, int.fract_ne], 
  have h2 : (λ (m : ℤ), int.fract (α * ↑m)) '' (@set.univ ℤ) = (λ (m : ℤ), (m : ℝ) - int.to_nat(α*m)) '' (@set.univ ℤ) := by auto,
  have h3 : (λ (m : ℤ), (m : ℝ) - int.to_nat(α*m)) '' (@set.univ ℤ) = (λ (m : ℤ), (m : ℝ) * 1 - int.to_nat(α*m * 1)) '' (@set.univ ℤ) := by auto,
  have h4 : (λ (m : ℤ), (m : ℝ) * 1 - int.to_nat(α*m * 1)) '' (@set.univ ℤ) = (λ (m : ℤ), (m : ℝ) - int.to_nat(α*m)) '' (@set.univ ℤ) := by auto,
  have h5 : (λ (m : ℤ), (m : ℝ) - int.to_nat(α*m)) '' (@set.univ ℤ) = (λ (m : ℤ), (m : ℝ) - int.to_nat ((α : ℝ) * (m : ℝ))) '' (@set.univ ℤ) := by auto,
  have h6 : (λ (m : ℤ), (m : ℝ) - int.to_nat ((α : ℝ) * (m : ℝ))) '' (@set.univ ℤ) = (λ (m : ℤ), (α : ℝ) * (m : ℝ) - int.to_nat ((α : ℝ) * (m : ℝ))) '' (@set.univ ℤ) := by auto,
  have h7 : (λ (m : ℤ), (α : ℝ) * (m : ℝ) - int.to_nat ((α : ℝ) * (m : ℝ))) '' (@set.univ ℤ) = (λ (m : ℤ), (α : ℝ) * (m : ℝ) - floor((α : ℝ) * (m : ℝ))) '' (@set.univ ℤ) := by auto,
  have h8 : (λ (m : ℤ), (α : ℝ) * (m : ℝ) - floor((α : ℝ) * (m : ℝ))) '' (@set.univ ℤ) = (λ (m : ℤ), (α : ℝ) * (m : ℝ) - int.to_nat (floor((α : ℝ) * (m : ℝ)))) '' (@set.univ ℤ) := by auto,
  have h9 : (λ (m : ℤ), (α : ℝ) * (m : ℝ) - int.to_nat (floor((α : ℝ) * (m : ℝ)))) '' (@set.univ ℤ) = (λ (m : ℤ), (α : ℝ) * ↑m - int.to_nat (floor((α : ℝ) * ↑m))) '' (@set.univ ℤ) := by auto,
  have h10 : (λ (m : ℤ), (α : ℝ) * ↑m - int.to_nat (floor((α : ℝ) * ↑m))) '' (@set.univ ℤ) = (λ (m : ℤ), (α : ℝ) * ↑m - int.to_nat (floor(α * ↑m))) '' (@set.univ ℤ) := by auto,
  have h11 : (λ (m : ℤ), (α : ℝ) * ↑m - int.to_nat (floor(α * ↑m))) '' (@set.univ ℤ) = (λ (m : ℤ), (α : ℝ) * m - int.to_nat (floor(α * m))) '' (@set.univ ℤ) := by auto,
  have h12 : (λ (m : ℤ), (α : ℝ) * m - int.to_nat (floor(α * m))) '' (@set.univ ℤ) = (λ (m : ℤ), (α : ℝ) * m - int.to_nat (floor(α * ←m))) '' (@set.univ ℤ) := by auto,
  have h13 : (λ (m : ℤ), (α : ℝ) * m - int.to_nat (floor(α * ←m))) '' (@set.univ ℤ) = (λ (m : ℤ), (α : ℝ) * m - int.to_nat (floor(←α * m))) '' (@set.univ ℤ) := by auto,
  have h14 : (λ (m : ℤ), (α : ℝ) * m - int.to_nat (floor(←α * m))) '' (@set.univ ℤ) = (λ (m : ℤ), (α : ℝ) * m - int.to_nat (floor(←α * m))) '' (↑(@set.univ ℤ) : set ℤ) := by auto,
  have h15 : (λ (m : ℤ), (α : ℝ) * m - int.to_nat (floor(←α * m))) '' (↑(@set.univ ℤ) : set ℤ) = (λ (m : ℤ), α * m - int.to_nat (floor(←α * m))) '' (↑(@set.univ ℤ) : set ℤ) := by auto,
  have h16 : (λ (m : ℤ), α * m - int.to_nat (floor(←α * m))) '' (↑(@set.univ ℤ) : set ℤ) = (λ (m : ℤ), α * m - int.to_nat (floor(←α * m))) '' (@set.univ ℤ) := by auto,
  have h17 : (λ (m : ℤ), α * m - int.to_nat (floor(←α * m))) '' (@set.univ ℤ) = (λ (m : ℤ), α * m - @int.to_nat ℤ (floor(←α * m))) '' (@set.univ ℤ) := by auto,
  have h18 : (λ (m : ℤ), α * m - @int.to_nat ℤ (floor(←α * m))) '' (@set.univ ℤ) = (λ (m : ℤ), α * m - @int.to
end --Needs more than 2000 tokens!

--OUTPUT 5
theorem irrational_orbit_dense {α : ℝ} (hα_irrat : irrational α) : closure ((λ m : ℤ, int.fract (α * ↑m)) '' (@set.univ ℤ)) = set.Icc 0 1 := 
begin
    --show the inclusion going the other way:
    --Let $\alpha$ be an irrational number. Then for distinct $i, j \in \mathbb{Z}$, we must have $\{i \alpha\} \neq\{j \alpha\}$. If this were not true, then 
    --$$i \alpha-\lfloor i \alpha\rfloor=\{i \alpha\}=\{j \alpha\}=j \alpha-\lfloor j \alpha\rfloor,$$
    --which yields the false statement $\alpha=\frac{\lfloor i \alpha\rfloor-\lfloor j \alpha\rfloor}{i-j} \in \mathbb{Q}$. Hence,
    --$$S:=\{\{i \alpha\} \mid i \in \mathbb{Z}\}$$
    --is an infinite subset of $\left[0,1\right]$.
    have h1 : ∀ (i j : ℤ),  int.fract (α * ↑i) ≠ int.fract (α * ↑j) := 
    begin
        assume i j,
        assume h2 : int.fract (α * ↑i) = int.fract (α * ↑j),
        have h3 : α = (↑i) * (int.fract (α * ↑i)) = (↑j) * (int.fract (α * ↑j)) := by auto [mul_comm],
        have h4 : α = (↑i) * (int.fract (α * ↑j)) = (↑j) * (int.fract (α * ↑i)) := by auto [mul_comm, h2],
        have h5 : α = 
        ((↑i) * (int.fract (α * ↑j) - int.fract (α * ↑i))) / (↑i - ↑j) := by auto [h3, h4],
        have h6 : α = 
        ((↑i) * (int.fract (α * ↑j) - int.fract (α * ↑i))) / (↑i - ↑j) := by auto [mul_comm, h5],
        have h7 : ((↑i) * (int.fract (α * ↑j) - int.fract (α * ↑i))) / (↑i - ↑j)  = 
        ((↑j) * (int.fract (α * ↑i) - int.fract (α * ↑j))) / (↑j - ↑i) := by auto [mul_comm, h6, h4],
        have h8 : ((↑i) * (int.fract (α * ↑j) - int.fract (α * ↑i))) / (↑i - ↑j)  = 
        ((↑j) * (int.fract (α * ↑i) - int.fract (α * ↑j))) / (↑j - ↑i) := by auto [int.fract_eq_of_nat_mul_eq_self, h7],
        have h9 : ((↑i) * (int.fract (α * ↑j) - int.fract (α * ↑i))) * ((↑j) - ↑i) = 
        ((↑j) * (int.fract (α * ↑i) - int.fract (α * ↑j))) * ((↑i) - ↑j) := by auto [h8, mul_comm],
        have h10 : ((↑i) * (int.fract (α * ↑j) - int.fract (α * ↑i))) * ((↑j) - ↑i) = 
        ((↑j) * (int.fract (α * ↑i) - int.fract (α * ↑j))) * ((↑i) - ↑j) := by auto [mul_comm, h9],
        have h11 : ((↑i) * (int.fract (α * ↑j) - int.fract (α * ↑i))) * ((↑j) - ↑i) = 
        ((↑j) * (int.fract (α * ↑i) - int.fract (α * ↑j))) * ((↑i) - ↑j) := by auto [mul_comm, h10],
        have h12 : ((↑j) - ↑i) * ((↑i) * (int.fract (α * ↑j) - int.fract (α * ↑i))) =
        ((↑j) - ↑i) * ((↑j) * (int.fract (α * ↑i) - int.fract (α * ↑j)))  := by auto [mul_comm, h11],
        have h13 : ((↑j) - ↑i) * ((↑i) * (int.fract (α * ↑j) - int.fract (α * ↑i))) =
        ((↑j) - ↑i) * ((↑j) * (int.fract (α * ↑i) - int.fract (α * ↑j)))  := by auto [mul_comm, h12],
        have h14 : ((↑i) - ↑j) * ((↑i) * (int.fract (α * ↑j) - int.fract (α * ↑i))) =
        ((↑i) - ↑j) * ((↑j) * (int.fract (α * ↑i) - int.fract (α * ↑j)))  := by auto [h13, mul_comm],
        have h15 : ((↑j) - ↑i) * ((↑i) * (int.fract (α * ↑j) - int.fract (α * ↑i))) =
        ((↑i) - ↑j) * ((↑j) * (int.fract (α * ↑i) - int.fract (α * ↑j)))  := by auto [mul_comm, h14],
        have h16 : ((↑j) - ↑i) * ((↑i) * (int.fract (α * ↑j) - int.fract (α * ↑i))) =
        ((↑i) - ↑j) * ((↑j) * (int.fract (α * ↑i) - int.fract (α * ↑j)))  := by auto [mul_comm, h15],
        have h17 : ((↑i) - ↑j) * ((↑j) * (int.fract (α * ↑j) - int.fract (α * ↑i))) =
        ((↑j) - ↑i) * ((↑i) * (int.fract (α * ↑i) - int.fract (α * ↑j)))  := by auto [h16, mul_comm],
        have h18 : ((↑i) - ↑j) * ((↑j) * (int.fract (α * ↑j) - int.fract (α * ↑i))) =
        ((↑j) - ↑i) * ((↑i) * (int.fract (α * ↑i) - int.fract (α * ↑j)))  := by auto [mul_comm, h17],
        have h19 : (↑i) * (((↑j) - ↑i) * (int.fract (α * ↑j) - int.fract (α * ↑i))) =
        (↑i) * (((↑j) - ↑i) * (int.fract (α * ↑i) - int.fract (α * ↑j)))  := by auto [mul_assoc, mul_comm],
        have h20 : (↑i) * (((↑j) - ↑i) * (int.fract (α * ↑j) - int.fract (α * ↑i))) =
        (↑i) * (((↑j) - ↑i) * (int.fract (α * ↑i) - int.fract (α * ↑j)))  := by auto [mul_comm, h19],
        have h21 : (↑j) * (((↑i) - ↑j) * (int.fract (α * ↑j) - int.fract (α * ↑i))) =
        (↑i) * (((↑j) - ↑i) * (int.fract (α * ↑i) - int.fract (α * ↑j)))  := by auto [h18, h20, mul_comm],
        have h22 : (↑j) * (((↑i) - ↑j) * (int.fract (α * ↑j) - int.fract (α * ↑i))) =
        (↑i) * (((↑j) -
end --Needs more than 2000 tokens!

--OUTPUT 6
theorem irrational_orbit_dense {α : ℝ} (hα_irrat : irrational α) : closure ((λ m : ℤ, int.fract (α * ↑m)) '' (@set.univ ℤ)) = set.Icc 0 1 :=
begin
  --Let $\alpha$ be an irrational number. Then for distinct $i, j \in \mathbb{Z}$, we must have $\{i \alpha\} \neq\{j \alpha\}$.
  have h1 : ∀ (i j : ℤ), i ≠ j → int.fract (α * ↑i) ≠ int.fract (α * ↑j), 
  assume (i j : ℤ) (h_dist : i ≠ j),
    
    --If this were not true, then
    have h1 : (i ≠ j ∨ int.fract (α * ↑i) = int.fract (α * ↑j)) → ∃ (q : ℚ), α = (q : ℝ), 
    from by auto [int.fract_mul_add_floor],

    push_neg at h_dist,
    have h2 : ¬ (∃ (q : ℚ), α = (q : ℝ)), from by auto [hα_irrat],
    show int.fract (α * ↑i) ≠ int.fract (α * ↑j), from by auto [h1, h2],
  
  --Hence, $S:=\{\{i \alpha\} \mid i \in \mathbb{Z}\}$ is an infinite subset of $\left[0,1\right]$.
  have S : set ℤ := (λ (i : ℤ), int.fract (α * ↑i)),
  have h3 : set.univ ⊆ S, from by auto [int.fract_mul_add_floor],
  have h4 : ∀ (i : ℤ), int.fract (α * ↑i) ∈ set.Icc 0 1, from by auto [int.fract_nonneg, int.fract_lt_one],
  have h5 : S ⊆ set.Icc 0 1, from by auto [h4],
  have h6 : (λ (m : ℤ), int.fract (α * ↑m)) '' set.univ ⊆ set.Icc 0 1, from by auto [h3, h5],
  have h7 : (λ (m : ℤ), int.fract (α * ↑m)) '' set.univ ≠ ∅, from by auto [exists_mem_image],
  have h8 : ∀ (y : set ℤ), y ≠ ∅ → ∃ (y' : set ℤ), ∀ (x : ℤ), x ∈ y → x ≠ y', from by auto [finite_iff_fintype_card, card_eq_zero, classical.by_contradiction],
  have h9 : ∃ (y' : set ℤ), ∀ (x : ℤ), x ∈ (λ (m : ℤ), int.fract (α * ↑m)) '' set.univ → x ≠ y', from by auto [h8, h7],
  have h10 : ∃ (y' : set ℤ), ∀ (x : ℤ), x ∈ S → x ≠ y', from by auto [h8, h7, h3],
  have h11 : ∀ (x y : ℤ), x ∈ S → y ∈ S → int.fract (α * ↑x) ≠ int.fract (α * ↑y), from by auto [h1, h10],

  --By the Bolzano-Weierstrass theorem, $S$ has a limit point in $[0, 1]$. One can thus find pairs of elements of $S$ that are arbitrarily close.
  have h12 : is_closed (set.Icc 0 1), from by auto [set.is_closed_Icc],
  have h13 : is_closed_of_is_closed_of_subset ((λ (m : ℤ), int.fract (α * ↑m)) '' set.univ) (set.Icc 0 1), from by auto [h5, h12],
  have h14 : (λ (m : ℤ), int.fract (α * ↑m)) '' set.univ ∈ closure (set.Icc 0 1), from by auto [h13, closure_mono],
  have h15 : set.Icc 0 1 ⊆ closure (set.Icc 0 1), from by auto [set.Icc_subset_closure],
  have h16 : (λ (m : ℤ), int.fract (α * ↑m)) '' set.univ ⊆ closure (set.Icc 0 1), from by auto [h14, h6, h15],

  --Since (the absolute value of) the difference of any two elements of $S$ is also an element of $S$, it follows that $0$ is a limit point of $S$.
  have h17 : ∀ (i j k : ℤ), (i ≠ j) → k ∈ S → k ∈ S, from by auto [int.fract_nonneg, int.fract_lt_one],
  have h18 : 0 ∈ closure ((λ (m : ℤ), int.fract (α * ↑m)) '' set.univ), from by auto [h16, closure_nonempty],
  have h19 : ∀ (i j : ℤ), (i ≠ j) → int.fract (α * ↑i) ∈ ((λ (m : ℤ), int.fract (α * ↑m)) '' set.univ) → int.fract (α * ↑j) ∈ ((λ (m : ℤ), int.fract (α * ↑m)) '' set.univ), from by auto [h17],
  have h20 : ∀ (i j : ℤ), (i ≠ j) → int.fract (α * ↑i) ∈ closure ((λ (m : ℤ), int.fract (α * ↑m)) '' set.univ) → int.fract (α * ↑j) ∈ closure ((λ (m : ℤ), int.fract (α * ↑m)) '' set.univ), from by auto [h16, h19],

  --To show that $S$ is dense in $[0, 1]$, consider $y \in[0,1]$, and $\epsilon>0$. Then by selecting $x \in S$ such that $\{x\}<\epsilon$ (which exists as $0$ is a limit point), and $N$ such that $N \cdot\{x\} \leq y<(N+1) \cdot\{x\}$, we get: $|y-\{N x\}|<\epsilon$.
  have h21 : ∀ (y ε : ℝ), (y ∈ set.Icc 0 1) → (ε > 0) → ∃ (n : ℕ), (let k := (↑y * ↑n : ℝ) in ((k - 1 : ℝ) < (int.fract (α * ↑k)) ∧ (int.fract (α * ↑k) < k))) ∧ (abs (y - int.fract (α * ↑n)) < ε),
  begin
    assume (y ε : ℝ) (h_y : y ∈ set.Icc 0 1) (h_ε : ε > 0),
    use ((1 + (y / (ε / 2))) : ℝ),
    have h22 : (ε / 2) > 0, from by auto [h_ε, div_pos],
    have h23 : (2: ℝ) > 0, from by auto [rat.num_pos],
    have h23 : (y / (ε / 2)) ∈ set.Icc 0 1, from by auto [h_y, h22, h23, zero_div, div_lt_iff],
    have h25 : (y / (ε / 2)) ∈ set.Icc 0 1, from by auto [h_y, h22, h23, zero_div, div_lt_iff],
    have h26 : (1 + (y / (ε / 2))) - 1 < int.fract (α * (1 + (y / (ε / 2)))) ∧ int.fract (α * (1 + (y / (ε / 2)))) < 1 + (y / (ε / 2)), 
    from by auto [int.fract_mul_
end --Needs more than 2000 tokens!

--OUTPUT 7
theorem irrational_orbit_dense {α : ℝ} (hα_irrat : irrational α) : closure ((λ m : ℤ, int.fract (α * ↑m)) '' (@set.univ ℤ)) = set.Icc 0 1 := 
begin
  --The fractional parts of the integer multiples of `α` form a dense subset of the unit interval
  have h4 : closure ((λ m : ℤ, int.fract (α * ↑m)) '' (@set.univ ℤ)) = set.Icc 0 1, 
  from by auto using @real_dense_fract_int_multiples α,
  show closure ((λ m : ℤ, int.fract (α * ↑m)) '' (@set.univ ℤ)) = set.Icc 0 1,
  from by auto [h4],
end

--OUTPUT 8
theorem irrational_orbit_dense {α : ℝ} (hα_irrat : irrational α) : closure ((λ m : ℤ, int.fract (α * ↑m)) '' (@set.univ ℤ)) = set.Icc 0 1 :=
begin
    --By the Bolzano-Weierstrass theorem, $S$ has a limit point in $[0, 1]$. One can thus find pairs of elements of $S$ that are arbitrarily close. Since (the absolute value of) the difference of any two elements of $S$ is also an element of $S$, it follows that $0$ is a limit point of $S$.
    have h1 : ∀ (x : ℤ), ∃ (m : ℤ), abs (x - m) < 1 := 
    by auto [bounded_iff.mp],

    --To show that $S$ is dense in $[0, 1]$, consider $y \in[0,1]$, and $\epsilon>0$. 
    --Then by selecting $x \in S$ such that $\{x\}<\epsilon$ (which exists as $0$ is a limit point), 
    --and $N$ such that $N \cdot\{x\} \leq y<(N+1) \cdot\{x\}$, we get: $|y-\{N x\}|<\epsilon$.
    have h2 : dense_fractional_parts_of_real_numbers α :=
    from begin
        assume (y : ℝ),
        assume (h3 : y ∈ set.Icc 0 1),
        cases h1 y with m h4,
        use (m : ℤ),
        use (abs h4 : ℝ),
        show m ∈ (λ (m : ℤ), int.fract (α * ↑m)) '' (@set.univ ℤ),
        from by auto using [fract_lt_one, fract_nonneg],
        have h5 : (α * ↑m) - m ∈ set.Icc 0 1,
        from begin
          have h6 : (α * ↑m) - m ≥ 0,
          from by auto [left_distrib, le_add_iff_nonneg_right, nat.cast_nonneg, nonneg_of_mul_nonneg_left, mul_nonneg, h3],
          have h7 : (α * ↑m) - m ≤ 1,
          from by auto [int.fract_le_one, mul_self_nonneg, h6],
          cases h4 with h4' h4'',
          show (α * ↑m) - m ∈ set.Icc 0 1, from by auto [int.cast_lt, int.cast_lt, int.cast_le, int.cast_le] using [h3, h7],
        end,
        have h8 : α * ↑m ∈ set.Icc y (y + abs (y - m)) ∧ y + abs (y - m) ∈ set.Icc (α * ↑m) 1,
        from begin
          have h9 : y ≤ α * ↑m ∧ α * ↑m ≤ y + abs (y - m),
          from by auto [mul_le_mul_left', nat.cast_nonneg, h3, h4, h1, abs_nonneg],
          show α * ↑m ∈ set.Icc y (y + abs (y - m)) ∧ y + abs (y - m) ∈ set.Icc (α * ↑m) 1, 
          from by auto [h4, h4'', h1, le_trans, int.cast_lt, abs_nonneg, le_of_lt, h3, h5, h9, set.Icc.mem_iff_mem_or_mem],
        end,
        have h9 : (y + abs (y - m) - 1) - (α * ↑m - y) < ↥(abs (y - m)),
        from by auto [int.fract_lt_one, h8, h5, add_lt_add_right, sub_lt_self, sub_lt_zero, abs_nonneg, h4, mul_self_nonneg, h3],
        have h10 : (y + abs (y - m) - 1) - (α * ↑m - y) = int.fract ((y + abs (y - m) - 1) - (α * ↑m - y)),
        from by auto [int.fract_eq_of_int_lt'],
        have h11 : (y + abs (y - m) - 1) = (α * ↑m - y) + ((y + abs (y - m) - 1) - (α * ↑m - y)),
        from by auto [sub_eq_add_neg, eq_comm],
        have h12 : (y + abs (y - m) - 1) = (α * ↑m - y) + int.fract ((y + abs (y - m) - 1) - (α * ↑m - y)),
        from by auto [h10, h11],
        have h13 : (y + abs (y - m) - 1) = (α * ↑m - y) + (int.fract ((y + abs (y - m) - 1) - (α * ↑m - y))),
        from by auto [h10, h11],
        have h14 : (α * ↑m) - (α * ↑m - y) = y,
        from by auto [sub_add_cancel],
        have h15 : α * ↑m - (α * ↑m - y) = y,
        from by auto [sub_add_cancel],
        have h16 : α * ↑m - (α * ↑m - y) = (y + abs (y - m) - 1) - int.fract ((y + abs (y - m) - 1) - (α * ↑m - y)),
        from by auto [sub_sub, h13],
        have h17 : α * ↑m - (α * ↑m - y) = (y + abs (y - m) - 1) - int.fract ((y + abs (y - m) - 1) - (α * ↑m - y)),
        from by auto [sub_sub, h13],
        have h18 : int.fract (y + abs (y - m) - 1) = α * ↑m - (α * ↑m - y),
        from by auto [sub_sub, h16, h15, h13],
        have h19 : int.fract (y + abs (y - m) - 1) = y,
        from by auto [sub_sub, h16, h15, h13, h14],
        have h20 : int.fract ((y + abs (y - m) - 1) - (α * ↑m - y)) = 0,
        from by auto [sub_sub, h10, h11, h13, h16, h15, h14],
        have h21 : int.fract ((y + abs (y - m) - 1) - (α * ↑m - y)) = 0,
        from by auto [sub_sub, h10, h11, h13, h16, h15, h14],
        --have h22 : (y + abs (y - m) - 1) = (α * ↑m - y) + 0,
        --from by auto [h16, h20],
        have h23 : (y + abs (y - m) - 1) = (α * ↑m - y),
        from by auto [sub_sub, h16, h20],
        have h24 : (α * ↑m - y) ≤ y + abs (y - m) - 1,
        from by auto [sub_sub, h23, h1, abs_nonneg, h4],
        have h25 : (y + abs (y - m) - 1) ≤ (y + abs (y - m)) - 1,
        from by auto [sub_sub, h3, h1, abs_nonneg, h4],
        have h26 : (α * ↑m - y) ≤ y + abs (y - m) - 1,
        from by auto [sub_sub, h23, h1, abs_nonneg, h4],
        have h27 : (y + abs (y - m) - 1) ≤ (y + abs (y - m)) - 1,
        from by auto [sub_sub, h3, h1, abs_nonneg, h4],
        have h28 : (α * ↑m - y) < y + abs (y - m),
        from by auto [sub_sub, h1, abs_nonneg, h4, h21,
end --Needs more than 2000 tokens!

--OUTPUT 9
theorem irrational_orbit_dense {α : ℝ} (hα_irrat : irrational α) : closure ((λ m : ℤ, int.fract (α * ↑m)) '' (@set.univ ℤ)) = set.Icc 0 1 :=
begin
  -- Let $\alpha$ be an irrational number. Then for distinct $i, j \in \mathbb{Z}$, we must have $\{i \alpha\} \neq\{j \alpha\}$.
  let S : set ℝ := {x : ℝ | ∃ i ∈ (univ : set ℤ), x = int.fract (α * ↑i)},
  have hS_not_empty : (S : set ℝ) ≠ ∅, from by auto [exists_intro 0],
  have hS_ne : ∀ i j ∈ (univ : set ℤ), ¬ (int.fract (α * ↑i) = int.fract (α * ↑j)), 
  from by auto [int.fract_eq_int_of_mul_int_eq, int.int_eq_zero_of_mul_int_eq, hα_irrat],

  -- By the Bolzano-Weierstrass theorem, $S$ has a limit point in $[0, 1]$.
  have h2 : has_limit_point S (Icc 0 1), from by auto using [bounded_Icc, compact_Icc],

  -- One can thus find pairs of elements of $S$ that are arbitrarily close.
  have h3 : ∀ (ε : ℝ), (ε > 0) → ∃ a b ∈ S, a ≠ b ∧ abs (a - b) ≤ ε,
  from by auto [h2, exists_limit_point_ne_of_mem] using [dist_comm],

  -- Since (the absolute value of) the difference of any two elements of $S$ is also an element of $S$, it follows that $0$ is a limit point of $S$.
  have h4 : 0 ∈ closure S, 
  from by auto [exists_limit_point_ne_of_mem, h3, hS_not_empty] using [dist_comm],

  -- To show that $S$ is dense in $[0, 1]$, consider $y \in[0,1]$, and $\epsilon>0$.
  have h5 : ∀ y ∈ Icc 0 1, ∀ (ε : ℝ), (ε > 0) → ∃ x ∈ S, abs (x - y) < ε,
  from by auto [h3, hα_irrat, le_of_lt, exists_int_between, exists_int_between'],

  -- Hence, $S$ is dense in $[0, 1]$.
  have h6 : closure S = Icc 0 1, from by auto [is_closed_closure, closure_eq_of_is_closed, subset_closure, hα_irrat, h4, h5, le_of_lt, le_of_lt'],

  -- $S$ is the set of all integer multiples of $\alpha$.
  have h7 : (λ m : ℤ, int.fract (α * ↑m)) '' (univ : set ℤ) = S, 
  from by auto [int.fract_eq_int_of_mul_int_eq, int.int_eq_zero_of_mul_int_eq],

  -- Hence, the closure of all integer multiples of $\alpha$ is $[0, 1]$.
  show closure ((λ m : ℤ, int.fract (α * ↑m)) '' (univ : set ℤ)) = Icc 0 1,
  from by auto [h6, h7],
end

--OUTPUT 10
theorem irrational_orbit_dense {α : ℝ} (hα_irrat : irrational α) : closure ((λ m : ℤ, int.fract (α * ↑m)) '' (@set.univ ℤ)) = set.Icc 0 1 :=
begin
  -- $α$ is irrational
  assume h,

  -- For distinct $i, j \in \mathbb{Z}$, we must have $\{i \alpha\} \neq\{j \alpha\}$. If this were not true, then ...
  have h1 : ∀ (i j : ℤ), i ≠ j → int.fract (α * ↑i) ≠ int.fract (α * ↑j),
  from by
    assume i j,
    assume h1 : i ≠ j,
    assume h2 : int.fract (α * ↑i) = int.fract (α * ↑j),
    have h3 : α = (int.fract (α * ↑i) + ⌊α * ↑i⌋) - (int.fract (α * ↑j) + ⌊α * ↑j⌋), by auto [mul_int_fract],
    have h4 : α = (int.fract (α * ↑i) + ⌊α * ↑i⌋) - (int.fract (α * ↑i) + ⌊α * ↑j⌋), by auto [h2], --[[rw ← h2]]
    have h5 : α = ⌊α * ↑i⌋ + ⌊α * ↑j⌋, from by rw [h4],
    have h6 : α = ⌊α * ↑i⌋ + ⌊α * ↑j⌋, from by auto [int.fract],
    have h7 : α = ⌊α * ↑i⌋ + ⌊α * ↑j⌋, from by auto [int.fract],
    have h8 : α ∈ ℚ, from by auto using [int.coe_nat_dvd],
    have h9 : irrational α, from by auto [hα_irrat],
    show false, from by auto using [h9, h8],

  -- Hence:
  -- $$
  -- S:=\{\{i \alpha\} \mid i \in \mathbb{Z}\}
  -- $$
  -- is an infinite subset of $\left[0,1\right]$.
  let S := { int.fract (α * ↑i) | (i : ℤ)},
  show infinite S, from by auto using [exists_int_nth, exists_int_lt, exists_int_pos],
  have hS_subset : S ⊆ set.Icc 0 1, from by auto [set.Icc_subset_iff, int.fract],

  -- The closure of $S$ is $\left[0,1\right]$.
  have h_closure : (closure S) = set.Icc 0 1, from by auto using [h1],

  -- To show that $S$ is dense in $[0, 1]$, consider $y \in[0,1]$, and $\epsilon>0$.
  assume y ε, 
  assume hy : (y : ℝ) ∈ set.Icc 0 1,
  assume hε : (ε : ℝ) > 0,

  -- Then by selecting $x \in S$ such that $\{x\}<\epsilon$
  cases set.exists_mem_of_ne_empty (set.mem_closure_iff'.mp (by auto [hε, hS_subset, hy])) with x hx,
  cases set.mem_closure_iff'.mp hx with N hN,
  have hN_subset : (λ n : ℤ, int.fract (α * ↑n)) '' ((set.Icc (-N) N) : set ℤ) ⊆ S, from by auto [set.image_subset_iff],
  have hN_subset_closure : (λ n : ℤ, int.fract (α * ↑n)) '' (set.Icc (-N) N) ⊆ closure S, from by auto [hN_subset, set.subset.trans],
  have hx_subset_closure : x ∈ closure S, from by auto [hN, hN_subset_closure],
  have hx_subset_S : x ∈ S, from by auto [hx, set.subset_iff.mp hx_subset_closure],
  have hx_in_int : x ∈ set.Icc 0 1, from by auto [hx_subset_S, hS_subset],
  have hx_pos : 0 < x, from by auto [hx_in_int, set.Ioo_subset_Icc_left, set.subset_iff],

  -- Then by selecting $x \in S$ such that $\{x\}<\epsilon$ (which exists as $0$ is a limit point),
  cases set.exists_mem_of_ne_empty (set.mem_closure_iff'.mp (by auto [hε, hS_subset, hx_pos])) with x' hx',
  cases set.mem_closure_iff'.mp hx' with N' hN',
  have hN'_subset : (λ n : ℤ, int.fract (α * ↑n)) '' ((set.Icc (-N') N') : set ℤ) ⊆ S, from by auto [set.image_subset_iff],
  have hN'_subset_closure : (λ n : ℤ, int.fract (α * ↑n)) '' (set.Icc (-N') N') ⊆ closure S, from by auto [hN'_subset, set.subset.trans],
  have hx'_subset_closure : x' ∈ closure S, from by auto [hN', hN'_subset_closure],
  have hx'_subset_S : x' ∈ S, from by auto [hx', set.subset_iff.mp hx'_subset_closure],
  have hx'_in_int : x' ∈ set.Icc 0 1, from by auto [hx'_subset_S, hS_subset],
  have hx'_pos : 0 < x', from by auto [hx'_in_int, set.Ioo_subset_Icc_left, set.subset_iff],
  have hx'_less : x' < ε, from by auto [hε, hx'_subset_closure, set.mem_closure_iff'.mp, set.mem_Icc_iff],

  -- and $N$ such that $N \cdot\{x\} \leq y<(N+1) \cdot\{x\}$,
  have h_fract_lt_one : ∀ x : ℤ, int.fract x < (1 : ℝ), from by auto [int.coe_nat_lt, int.coe_nat_ne_zero],
  cases exists_nat_one_add_le (int.fract (α * ↑N')) h_fract_lt_one with N hN,
  have hN_pos : (N : ℝ) > 0, from by auto,
  have hN'_pos : (N' : ℝ) > 0, from by auto,
  have hN_N'_pos : (↑N : ℝ) > ↑N', from by auto,
  have hN_pos_int : N > 0, from by auto,
  have hN'_pos_int : N' > 0, from by auto,
  have hN_N'_pos_int : N > N', from by auto,
  have hN_pos : (N : ℝ) > 0, from by auto,
  have hN_pos_int : N > 0, from by auto,
  have hN_mul_x_pos : ((↑N : ℝ) * x) > 0, from by auto [hN_pos],
  have hN_mul_x_pos_int : (N * x) > 0, from by auto [int.coe_nat_pos],
  
  -- we get: $|y-\{N x\}|<\epsilon$
  have h_le : y ≤ (↑N : ℝ) * x,
  from by auto [int.coe_nat_le, int.
end --Needs more than 2000 tokens!

/- FEW SHOT PROMPTS TO CODEX(START)
/--`theorem`
Power Set is Closed under Intersection
Let $S$ be a set.

Let $\powerset S$ be the power set of $S$.


Then:
:$\forall A, B \in \powerset S: A \cap B \in \powerset S$
`proof`
Let $A, B \in \powerset S$.

Then by the definition of power set, $A \subseteq S$ and $B \subseteq S$.

From Intersection is Subset we have that $A \cap B \subseteq A$.

It follows from Subset Relation is Transitive that $A \cap B \subseteq S$.

Thus $A \cap B \in \powerset S$ and closure is proved.
{{qed}}
-/
theorem power_set_intersection_closed {α : Type*} (S : set α) : ∀ A B ∈ 𝒫 S, (A ∩ B) ∈ 𝒫 S :=
begin
  -- $A$ and $B$ are sets. $A$ and $B$ belong to power set of $S$
  assume (A : set α) (hA : A ∈ 𝒫 S) (B : set α) (hB : B ∈ 𝒫 S),
  -- Then $A ⊆ S$ and $B ⊆ S$, by power set definition
  have h1 : (A ⊆ S) ∧ (B ⊆ S), from by auto [set.subset_of_mem_powerset, set.subset_of_mem_powerset],
  -- Then $(A ∩ B) ⊆ A$, by intersection of set is a subset
  have h2 : (A ∩ B) ⊆ A, from by auto [set.inter_subset_left],
  -- Then $(A ∩ B) ⊆ S$, by subset relation is transitive 
  have h3 : (A ∩ B) ⊆ S, from by auto [set.subset.trans],
  -- Hence $(A ∩ B) ∈  𝒫 S$, by power set definition
  show (A ∩ B) ∈  𝒫 S, from by auto [set.mem_powerset],
end

/--`theorem`
Square of Sum
 :$\forall x, y \in \R: \paren {x + y}^2 = x^2 + 2 x y + y^2$
`proof`
Follows from the distribution of multiplication over addition:

{{begin-eqn}}
{{eqn | l = \left({x + y}\right)^2
      | r = \left({x + y}\right) \cdot \left({x + y}\right)
}}
{{eqn | r = x \cdot \left({x + y}\right) + y \cdot \left({x + y}\right)
      | c = Real Multiplication Distributes over Addition
}}
{{eqn | r = x \cdot x + x \cdot y + y \cdot x + y \cdot y
      | c = Real Multiplication Distributes over Addition
}}
{{eqn | r = x^2 + 2xy + y^2
      | c = 
}}
{{end-eqn}}
{{qed}}
-/
theorem square_of_sum (x y : ℝ) : (x + y)^2 = (x^2 + 2*x*y + y^2) := 
begin
  -- expand the power
  calc (x + y)^2 = (x+y)*(x+y) : by auto [sq]
  -- distributive property of multiplication over addition gives:
  ... = x*(x+y) + y*(x+y) : by auto [add_mul]
  -- applying the above property further gives:
  ... = x*x + x*y + y*x + y*y : by auto [mul_comm, add_mul] using [ring]
  -- rearranging the terms using commutativity and adding gives:
  ... = x^2 + 2*x*y + y^2 : by auto [sq, mul_comm] using [ring]
end

/--`theorem`
Identity of Group is Unique
Let $\struct {G, \circ}$ be a group. Then there is a unique identity element $e \in G$.
`proof`
From Group has Latin Square Property, there exists a unique $x \in G$ such that:
:$a x = b$

and there exists a unique $y \in G$ such that:
:$y a = b$

Setting $b = a$, this becomes:

There exists a unique $x \in G$ such that:
:$a x = a$

and there exists a unique $y \in G$ such that:
:$y a = a$

These $x$ and $y$ are both $e$, by definition of identity element.
{{qed}}
-/
theorem group_identity_unique {G : Type*} [group G] : ∃! e : G, ∀ a : G, e * a = a ∧ a * e = a :=
begin
  -- Group has Latin Square Property
  have h1 : ∀ a b : G, ∃! x : G, a * x = b, from by auto using [use (a⁻¹ * b)],
  have h2 : ∀ a b : G, ∃! y : G, y * a = b, from by auto using [use b * a⁻¹], 

  -- Setting $b = a$, this becomes:
  have h3 : ∀ a : G, ∃! x : G, a * x = a, from by auto [h1],
  have h4 : ∀ a : G, ∃! y : G, y * a = a, from by auto [h2],

  -- These $x$ and $y$ are both $(1 : G)$, by definition of identity element
  have h5 : ∀ a : G, classical.some (h3 a).exists = (1 : G), from by auto [exists_unique.unique, h3, classical.some_spec, exists_unique.exists, mul_one],
  have h6 : ∀ a : G, classical.some (h4 a).exists = (1 : G), from by auto [exists_unique.unique, h4, classical.some_spec, exists_unique.exists, one_mul],

  show ∃! e : G, ∀ a : G, e * a = a ∧ a * e = a, from by auto [h3, h4, exists_unique.unique, classical.some_spec, exists_unique.exists] using [use (1 : G)],
end

/--`theorem`
Squeeze Theorem for Real Numbers
Let $\sequence {x_n}$, $\sequence {y_n}$ and $\sequence {z_n}$ be sequences in $\R$.

Let $\sequence {y_n}$ and $\sequence {z_n}$ both be convergent to the following limit:
:$\ds \lim_{n \mathop \to \infty} y_n = l, \lim_{n \mathop \to \infty} z_n = l$

Suppose that:
:$\forall n \in \N: y_n \le x_n \le z_n$


Then:
:$x_n \to l$ as $n \to \infty$
that is:
:$\ds \lim_{n \mathop \to \infty} x_n = l$

`proof`
From Negative of Absolute Value:
:$\size {x - l} < \epsilon \iff l - \epsilon < x < l + \epsilon$

Let $\epsilon > 0$.

We need to prove that:
:$\exists N: \forall n > N: \size {x_n - l} < \epsilon$

As $\ds \lim_{n \mathop \to \infty} y_n = l$ we know that:
:$\exists N_1: \forall n > N_1: \size {y_n - l} < \epsilon$

As $\ds \lim_{n \mathop \to \infty} z_n = l$ we know that:
:$\exists N_2: \forall n > N_2: \size {z_n - l} < \epsilon$


Let $N = \max \set {N_1, N_2}$.

Then if $n > N$, it follows that $n > N_1$ and $n > N_2$.

So:
:$\forall n > N: l - \epsilon < y_n < l + \epsilon$
:$\forall n > N: l - \epsilon < z_n < l + \epsilon$

But:
:$\forall n \in \N: y_n \le x_n \le z_n$

So:
:$\forall n > N: l - \epsilon < y_n \le x_n \le z_n < l + \epsilon$

and so:
:$\forall n > N: l - \epsilon < x_n < l + \epsilon$

So:
:$\forall n > N: \size {x_n - l} < \epsilon$

Hence the result.
{{qed}}

-/
theorem squeeze_theorem_real_numbers (x y z : ℕ → ℝ) (l : ℝ) : 
let seq_limit : (ℕ → ℝ) → ℝ → Prop :=  λ (u : ℕ → ℝ) (l : ℝ), ∀ ε > 0, ∃ N, ∀ n > N, |u n - l| < ε in
 seq_limit y l → seq_limit z l →  (∀ n : ℕ, (y n) ≤ (x n) ∧ (x n) ≤ (z n)) → seq_limit x l :=
begin
  assume seq_limit (h2 : seq_limit y l) (h3 : seq_limit z l) (h4 : ∀ (n : ℕ), y n ≤ x n ∧ x n ≤ z n) (ε), 

  --From Negative of Absolute Value: $\size {x - l} < \epsilon \iff l - \epsilon < x < l + \epsilon$
  have h5 : ∀ x, |x - l| < ε ↔ (((l - ε) < x) ∧ (x < (l + ε))), 
  from by auto [abs_sub_lt_iff] using [linarith],
  
  --Let $\epsilon > 0$.
  assume (h7 : ε > 0),

  --As $\ds \lim_{n \mathop \to \infty} y_n = l$ we know that $\exists N_1: \forall n > N_1: \size {y_n - l} < \epsilon$
  cases h2 ε h7 with N1 h8,

  --As $\ds \lim_{n \mathop \to \infty} z_n = l$ we know that $\exists N_2: \forall n > N_2: \size {z_n - l} < \epsilon$
  cases h3 ε h7 with N2 h9,
  
  --Let $N = \max \set {N_1, N_2}$.
  let N := max N1 N2,
  use N,

  --Then if $n > N$, it follows that $n > N_1$ and $n > N_2$.
  have h10 : ∀ n > N, n > N1 ∧ n > N2 := by auto [lt_of_le_of_lt, le_max_left, le_max_right],
  
  --$\forall n > N: l - \epsilon < y_n < l + \epsilon$
  --$\forall n > N: l - \epsilon < z_n < l + \epsilon$
  --$\forall n \in \N: y_n \le x_n \le z_n$
  --So $\forall n > N: l - \epsilon < y_n \le x_n \le z_n < l + \epsilon$
  have h11 : ∀ n > N, (((l - ε) < (y n)) ∧ ((y n) ≤ (x n))) ∧ (((x n) ≤ (z n)) ∧ ((z n) < l+ε)), 
  from by auto [h8, h10, h5, h9],

  --$\forall n > N: l - \epsilon < x_n < l + \epsilon$
  have h15 : ∀ n > N, ((l - ε) < (x n)) ∧ ((x n) < (l+ε)), 
  from by auto [h11] using [linarith],

  --So $\forall n > N: \size {x_n - l} < \epsilon$
  --Hence the result
  show  ∀ (n : ℕ), n > N → |x n - l| < ε, 
  from by auto [h5, h15], 

end

/--`theorem`
Density of irrational orbit
The fractional parts of the integer multiples of an irrational number form a dense subset of the unit interval
`proof`
Let $\alpha$ be an irrational number. Then for distinct $i, j \in \mathbb{Z}$, we must have $\{i \alpha\} \neq\{j \alpha\}$. If this were not true, then
$$
i \alpha-\lfloor i \alpha\rfloor=\{i \alpha\}=\{j \alpha\}=j \alpha-\lfloor j \alpha\rfloor,
$$
which yields the false statement $\alpha=\frac{\lfloor i \alpha\rfloor-\lfloor j \alpha\rfloor}{i-j} \in \mathbb{Q}$. Hence,
$$
S:=\{\{i \alpha\} \mid i \in \mathbb{Z}\}
$$
is an infinite subset of $\left[0,1\right]$.

By the Bolzano-Weierstrass theorem, $S$ has a limit point in $[0, 1]$. One can thus find pairs of elements of $S$ that are arbitrarily close. Since (the absolute value of) the difference of any two elements of $S$ is also an element of $S$, it follows that $0$ is a limit point of $S$.

To show that $S$ is dense in $[0, 1]$, consider $y \in[0,1]$, and $\epsilon>0$. Then by selecting $x \in S$ such that $\{x\}<\epsilon$ (which exists as $0$ is a limit point), and $N$ such that $N \cdot\{x\} \leq y<(N+1) \cdot\{x\}$, we get: $|y-\{N x\}|<\epsilon$.

QED
-/
theorem  irrational_orbit_dense {α : ℝ} (hα_irrat : irrational α) : closure ((λ m : ℤ, int.fract (α * ↑m)) '' (@set.univ ℤ)) = set.Icc 0 1 :=
FEW SHOT PROMPTS TO CODEX(END)-/
